IF EXISTS (SELECT * FROM SYS.PROCEDURES WHERE NAME = 'P_LGPD_PROCESSAMENTO_PESSOA')
BEGIN 
	DROP PROCEDURE P_LGPD_PROCESSAMENTO_PESSOA
END 

GO 
/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 21081901
'Job.................:  
'Nome................: P_LGPD_PROCESSAMENTO_PESSOA 
'Objetivo............: Procedure responsavel pela chamada das demais procedures de anonimizacao
e responsavel por criar tabela LGPD_LOG_PROCESSAMENTO
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 15/09/2021
'Alterado por........: Marcos barros
'Criado por..........: Rayane
'=======================================================================================
Reg #21081901 - Implementado criao da tabela LGPD_LOG_PROCESSAMENTO caso nao exista  - Marcos Barros
*/

CREATE PROCEDURE P_LGPD_PROCESSAMENTO_PESSOA (@CD_PESSOA INT, @TIPO TINYINT)
AS
	IF OBJECT_ID('LGPD_LOG_PROCESSAMENTO') IS NULL
	BEGIN 
		CREATE TABLE LGPD_LOG_PROCESSAMENTO (
			ID			BIGINT IDENTITY (1,1),
			CD_PESSOA	BIGINT,
			DT_CAD		DATETIME, 
			NM_FM		VARCHAR(50)COLLATE SQL_LATIN1_GENERAL_CP1_CI_AS,
			TP_PROC		TINYINT NOT NULL,
			CONSTRAINT PK_LGPD_LOG_PROCESSAMENTO PRIMARY KEY (ID)
		)
	PRINT 'CRIADA TABELA LGPD_LOG_PROCESSAMENTO';
	END ;

	IF @TIPO = 0
	BEGIN
		print 'Processando lgpd cliente'
		EXEC P_LGPD_PROCESSAMENTO_CLI @CD_PESSOA
	END

	IF @TIPO = 1
	BEGIN
		print 'Processando lgpd emitente cheque'
		EXEC P_LGPD_PROCESSAMENTO_CHQ @CD_PESSOA
	END

	IF @TIPO = 2
	BEGIN
		print 'Processando lgpd Fornecedor p. fisica'
		EXEC P_LGPD_PROCESSAMENTO_FORN @CD_PESSOA
	END

	IF @TIPO = 3
	BEGIN
		print 'Processando lgpd funcionario'
		EXEC P_LGPD_PROCESSAMENTO_FUNC @CD_PESSOA
	END

	IF @TIPO = 4
	BEGIN
		print 'Processando lgpd usuario Sngpc'
		EXEC P_LGPD_PROCESSAMENTO_SNGPC @CD_PESSOA
	END 

	 